﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using System.ServiceModel;
using BMS.FaultContracts;
using BMS.Facade.Fault;

namespace BMS.Workflows.CustomActivities.Utils
{
    public class HandleGenericServiceFault : CodeActivity
    {
        public InArgument<Exception> FaultData { get; set; }
        public OutArgument<FaultException<GenericWFServiceFault>> FaultResult { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Exception exception = this.FaultData.Get<Exception>(context);
                if ((exception as FaultException<ConfigValueException>) != null)
                {
                    FaultException<ConfigValueException> fault = null;
                    fault = exception as FaultException<ConfigValueException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                if ((exception as FaultException<CustomSQLException>) != null)
                {
                    FaultException<CustomSQLException> fault = null;
                    fault = exception as FaultException<CustomSQLException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                if ((exception as FaultException<DefaultConfigException>) != null)
                {
                    FaultException<DefaultConfigException> fault = null;
                    fault = exception as FaultException<DefaultConfigException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                if ((exception as FaultException<EntityNotFoundException>) != null)
                {
                    FaultException<EntityNotFoundException> fault = null;
                    fault = exception as FaultException<EntityNotFoundException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                if ((exception as FaultException<NullParameterException>) != null)
                {
                    FaultException<NullParameterException> fault = null;
                    fault = exception as FaultException<NullParameterException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                if ((exception as FaultException<OtherException>) != null)
                {
                    FaultException<OtherException> fault = null;
                    fault = exception as FaultException<OtherException>;
                    if (fault != null)
                    {
                        this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    }
                    return;
                }
                this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = exception }));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
